<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<header class="entry-header">
		<?php $gmaps = cs_get_option('gmaps_embed', '');
			if ( is_page_template( 'page-contact-us.php' ) && !empty($gmaps) ) { 
				echo '<div class="lightrr__gmaps-embed">'. wp_kses($gmaps, array('iframe' => array('src' => array())) ) .'</div>';
			}
			else { lightrr_post_head(); }
		?>
		<div class="entry-meta">
			<?php echo get_avatar( get_the_author_meta('ID'), 60 ); ?>
			<a class="author" href="<?php echo esc_url( get_author_posts_url(get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?></a> &#47;
			<a href="<?php esc_url( the_permalink() ); ?>"><time class="entry-date published" datetime="<?php esc_attr (the_time( 'c' ) ); ?>"> <?php the_time( get_option( 'date_format' ) ); ?>, <?php the_time( get_option( 'time_format' ) ); ?></time></a>
		</div>

		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
	</header> <!--/entry-header -->

	<div class="entry-content">

		<div class="lightrr__full-entry">
			<?php the_content(); ?>
			<?php $args = array('before'=> '<p class="lightrr__posts-pagination"><span class="pgopen">' . esc_html__('Pages:', 'lightrr') .'','after'=> '</p>','link_before'=> '','link_after'=> '','next_or_number'=> 'number','pagelink'=> '<span>%</span>','echo'=> 1); wp_link_pages( $args ); ?>
		</div> <!--/lightrr__full-entry-->

		<?php if ( cs_get_option( 'share_buttons', true ) && !is_page_template( 'page-contact-us.php' ) ) { ?>
			<div class="lightrr__info-share"><?php lightrr_share(); ?></div>
		<?php } ?>

	</div> <!--/entry-content-->

	<?php $author_desc = get_the_author_meta('description');
	if (cs_get_option('author_box', true) && !empty($author_desc) && !is_page_template( 'page-contact-us.php' ) ) : ?>
		<footer class="entry-footer author-bio-card author vcard">
			<h4><span><a class="url fn" href="<?php echo esc_url( get_author_posts_url(get_the_author_meta( 'ID' )) ); ?>"><?php esc_html_e('About','lightrr') ?> <?php the_author(); ?></a></span>
			<a class="mini-tag" href="<?php echo esc_url( get_author_posts_url(get_the_author_meta( 'ID' )) ); ?>"><?php esc_html_e('view all posts', 'lightrr'); ?></a>
			</h4>
			<?php echo get_avatar( get_the_author_meta('ID'), 100 ); ?>
			<p class="authorbio-description"><?php echo esc_html($author_desc); ?></p>
			<div class="lightrr__mini-icons hidden-xs"><?php lightrr_author_icons(); ?></div>
		</footer> <!--/entry-footer -->
	<?php endif; ?>

</article> <!--/post -->