<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 * Template Name: Homepage
 */
get_header();

?>

<section class="lightrr__hero">
	<div class="lightrr__hero--item" style="background-image:url('<?php echo get_template_directory_uri() ?>/img/bg__hero.jpg');">
		<div class="container">
			<div class="row">
				<div class="lightrr__hero--teaser">
					<h2>Tú puedes si lo quieres</h2>
					<h3>Obtener un crédito nunca había sido tan seguro, fácil y rápido.</h3>
					<div class="lightrr__hero--btn">
						<a href="<?php echo get_home_url(); ?>/solicitud">Solicita tu crédito</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="lightrr__queremos wow fadeIn">
   <div class="container">
      <div class="row">
         
         <div class="col-md-12">
            <div class="lightrr__queremos--title">
               <h3>Queremos ayudarte</h3>
            </div>
         </div>
         <div class="col-md-12">
            <div class="lightrr__queremos--desc">
               <p>Somos una empresa especializada en programas de financiamiento de bienes y servicios así como <strong>créditos personales y empresariales</strong> para colaborar en el crecimiento de nuestros clientes.
               Nuestro objetivo es ser la primera opción de crédito para personas físicas y morales en el mercado nacional.</p>
            </div>
         </div>
         <div class="col-md-6">
            <div class="lightrr__queremos--item">
               <div class="lightrr__queremos--centered">
                  <div class="lightrr__queremos--item--img">
                     <img src="<?php echo get_template_directory_uri(); ?>/img/queremos--icon-1.svg" alt="" />
                  </div>
                  <h4>Soy persona</h4>
                  <a href="<?php echo get_home_url(); ?>/servicios">Leer más <i class="far fa-chevron-right"></i></a>
               </div>
            </div>
         </div>
         <div class="col-md-6">
            <div class="lightrr__queremos--item">
               <div class="lightrr__queremos--centered">
                  <div class="lightrr__queremos--item--img">
                     <img src="<?php echo get_template_directory_uri(); ?>/img/queremos--icon-2.svg" alt="" />
                  </div>
                  <h4>Soy empresa</h4>
                  <a href="<?php echo get_home_url(); ?>/empresas">Leer más <i class="far fa-chevron-right"></i></a>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>





<section class="lightrr__prestamos" style="display:none;">
   <div class="container">
      <div class="d-flex align-content-center row">
         <div class="align-self-top col-md-4">
            <div class="lightrr__prestamos--teaser">
               <h4>Te prestamos <br />dinero para lo <br />que necesites</h4>
            </div>
         </div>
         <div class="align-self-top col-md-4">
            <div class="lightrr__prestamos--media">
               <img src="<?php echo get_template_directory_uri(); ?>/img/bg__money.jpg" alt="" />
            </div>
         </div>
         <div class="align-self-end col-md-4">
            <div class="lightrr__prestamos--desc">
               <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
               <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
               <div class="lightrr__prestamos--btn">
                  <a href="#">Leer más</a>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>






<section class="lightrr__porque wow fadeIn">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <div class="lightrr__porque--title">
               <h3>Por qué elegirnos</h3><br /><br /><br />
            </div>
         </div>
         <div class="col-md-4">
            <div class="lightrr__porque--item">
               <div class="lightrr__porque--centered">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__porque--item--img">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/beneficios--01.svg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__porque--item--desc">
                           <p>Competitividad, rapidez y facilidad</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-4">
            <div class="lightrr__porque--item">
               <div class="lightrr__porque--centered">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__porque--item--img">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/beneficios--02.svg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__porque--item--desc">
                           <p>Alta calidad en los servicios que proveemos</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-4">
            <div class="lightrr__porque--item">
               <div class="lightrr__porque--centered">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__porque--item--img">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/beneficios--03.svg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__porque--item--desc">
                           <p>Especialistas en el área.</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-4 offset-md-2">
            <div class="lightrr__porque--item">
               <div class="lightrr__porque--centered">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__porque--item--img">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/beneficios--04.svg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__porque--item--desc">
                           <p>Descuentos vía nómina</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-4">
            <div class="lightrr__porque--item">
               <div class="lightrr__porque--centered">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__porque--item--img">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/beneficios--05.svg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__porque--item--desc">
                           <p>Productos financieros que se adaptan a las necesidades de nuestros clientes</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>



<section class="lightrr__testimonios wow fadeIn" style="background-image:url('<?php echo get_template_directory_uri() ?>/img/bg__testimonios.jpg');">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <div class="lightrr__testimonios--title">
               <h3>Ellos confían en nosotros</h3>
            </div>
         </div>
      </div>

      
      <div class="owl-carousel owl-theme">
      <div class="item">
         <div class="row">
            <div class="col-md-6">
               <div class="lightrr__testimonios--item">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__testimonios--media">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/person--1.jpg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__testimonios--name">
                           <h3><span>Empresario</span> Lucía Andrade</h3>
                        </div>
                        <div class="lightrr__testimonios--bio">
                           <p>Lorem ipsum dolor sit amet, consectetur leo adipisicing elit, eiusmod tempor incididunt ut labore et dolore magna aliqua. a sunt expli.</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="col-md-6">
               <div class="lightrr__testimonios--item">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__testimonios--media">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/person--1.jpg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__testimonios--name">
                           <h3><span>Empresario</span> Regina Ruíz</h3>
                        </div>
                        <div class="lightrr__testimonios--bio">
                           <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. a sunt explicabo.</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <div class="item">
         <div class="row">
            <div class="col-md-6">
               <div class="lightrr__testimonios--item">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__testimonios--media">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/person--1.jpg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__testimonios--name">
                           <h3><span>Empresario</span> Francisco Shurcks</h3>
                        </div>
                        <div class="lightrr__testimonios--bio">
                           <p>Lorem ipsum dolor sit amet, consectetur leo adipisicing elit, eiusmod tempor incididunt ut labore et dolore magna aliqua. a sunt expli.</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="col-md-6">
               <div class="lightrr__testimonios--item">
                  <div class="row">
                     <div class="col-md-4">
                        <div class="lightrr__testimonios--media">
                           <img src="<?php echo get_template_directory_uri(); ?>/img/person--1.jpg" alt="" />
                        </div>
                     </div>
                     <div class="col-md-8">
                        <div class="lightrr__testimonios--name">
                           <h3><span>Empresario</span> Jorge Martínez</h3>
                        </div>
                        <div class="lightrr__testimonios--bio">
                           <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. a sunt explicabo.</p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      </div>



   </div>
</section>




<section class="lightrr__clientes wow fadeIn">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <div class="lightrr__clientes--title">
               <h3>Algunos de nuestros clientes</h3>
            </div>
         </div>
         <div class="col">
            <div class="lightrr__clientes--item">
               <div class="lightrr__clientes--item--img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/logo--azteca.png" alt="" />
               </div>
            </div>
         </div>
         <div class="col">
            <div class="lightrr__clientes--item">
               <div class="lightrr__clientes--item--img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/logo--cavad.png" alt="" />
               </div>
            </div>
         </div>
         <div class="col">
            <div class="lightrr__clientes--item">
               <div class="lightrr__clientes--item--img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/logo--totalplay.png" alt="" />
               </div>
            </div>
         </div>
         <div class="col">
            <div class="lightrr__clientes--item">
               <div class="lightrr__clientes--item--img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/logo--fiar.png" alt="" />
               </div>
            </div>
         </div>
         <div class="col">
            <div class="lightrr__clientes--item">
               <div class="lightrr__clientes--item--img">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/logo--fiar.png" alt="" />
               </div>
            </div>
         </div>
      </div>
   </div>
</section>



<?php get_footer(); ?>
