<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 */
?>

<div class="logo-section col-md-4 lightrr__footer-col">
	<?php if(cs_get_option('logo_uploader_footer', false)) : ?>
		<h2 class="logo-footer-img"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php lightrr_custom_logo('footer'); ?></a></h2>
	<?php else: ?>
		<h2 class="logo-footer"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h2>
	<?php endif; ?>

	<?php if (cs_get_option( 'footer_description' )) { echo '<p class="site-description">'.esc_html( cs_get_option( 'footer_description' ) ).'</p>'; } ?>

	<?php dynamic_sidebar( 'lightrr__footer-1' ); ?>

	<?php if (cs_get_option('footer_tag')){ echo '<div class="footer-tag"><p class="copy">'.esc_html( cs_get_option('footer_tag') ).'</p></div>'; } ?>
</div> <!-- /col-1 -->

<?php if (is_active_sidebar('lightrr__footer-2') ) : ?>
<div class="col-md-4 lightrr__footer-col second-col">
	<?php dynamic_sidebar( 'lightrr__footer-2' ); ?>
</div> <!-- /col-2 -->

<?php endif; ?>

<?php if (is_active_sidebar('lightrr__footer-3') ) : ?>
<div class="col-md-4 last-col lightrr__footer-col">
	<?php dynamic_sidebar( 'lightrr__footer-3' ); ?>
</div>  <!-- /col-3 -->
<?php endif; ?>