	<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 */
?><!DOCTYPE html> 
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<link rel="icon" href="<?php echo get_template_directory_uri(); ?>/img/favicon.png" type="image/x-icon" />
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php esc_url( bloginfo( 'pingback_url' ) ); ?>" />
<?php wp_head();
?>
</head>

<body <?php body_class(); ?>>

<section class="lightrr__mobile">
	<div class="lightrr__mobile--close">
		<i class="far fa-times"></i>
	</div>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="lightrr__mobile--logo">
					<a href="<?php echo get_home_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/img/fiar--logo-w.png" /></a>
				</div>
				<div class="lightrr__mobile--menu inline">
					<?php wp_nav_menu(array('container' => false, 'menu_id' => 'lightrr__principal-menu', 'menu_class' => 'lightrr__principal-menu', 'link_before' => '', 'theme_location' => 'lightrr__principal-menu')); ?>
				</div>
			</div>
		</div>
	</div>
</section>

<header class="lightrr__header">
	<div class="container">
		<div class="row">
			<div class="col-6 col-md-2">
				<div class="lightrr__header--logo">
					<a href="<?php echo get_home_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/img/fiar--logo.png" /></a>
				</div>
			</div>
			<div class="col-6 col-md-10">
				<div class="lightrr__header--toggle">
					<i class="fal fa-bars"></i>
				</div>
				<div class="lightrr__header--menu inline">
					<?php wp_nav_menu(array('container' => false, 'menu_id' => 'lightrr__principal-menu', 'menu_class' => 'lightrr__principal-menu', 'link_before' => '', 'theme_location' => 'lightrr__principal-menu')); ?>
				</div>
			</div>
		</div>
	</div>
</header>
