<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 */


add_action('add_meta_boxes', 'lightrr_meta_box_add');
add_action('admin_enqueue_scripts', 'lightrr_enqueue_scripts');

function lightrr_meta_box_add() {
	add_meta_box('metabx-dph', esc_html__('Post Options - lightrr Theme', 'lightrr'), 'lightrr_meta_box_cb', 'post', 'normal', 'high');
}

function lightrr_enqueue_scripts() {
	wp_enqueue_script('lightrr__metabox-js', get_template_directory_uri() . '/js/metabox.js', array('jquery'));
	wp_enqueue_style('lightrr__metabox-css', get_template_directory_uri() . '/css/metabox.css', array(), null, 'all');
}

function lightrr_meta_box_cb() {
	
	global $post;
	$values = get_post_custom($post->ID);
	
	$check_featured_post = isset($values['lightrr_meta_featured_post']) ? esc_attr($values['lightrr_meta_featured_post'][0]) : '';
	$check_disable_sidebar = isset($values['lightrr_meta_sidebar']) ? esc_attr($values['lightrr_meta_sidebar'][0]) : '';
	$check_review_post = isset($values['lightrr_meta_reviewon']) ? esc_attr($values['lightrr_meta_reviewon'][0]) : '';
	
	wp_nonce_field('lightrr_meta_box_nonce', 'meta_box_nonce');
?> 

<p><input type="checkbox" id="lightrr_meta_featured_post" name="lightrr_meta_featured_post" <?php checked($check_featured_post, true); ?> />
<label for="lightrr_meta_featured_post"><?php esc_html_e('Featured Post (Homepage)', 'lightrr') ?></label></p>

<p><input type="checkbox" id="lightrr_meta_sidebar" name="lightrr_meta_sidebar" <?php checked($check_disable_sidebar, true); ?> />
<label for="lightrr_meta_sidebar"><?php esc_html_e('Disable Sidebar', 'lightrr') ?></label></p>

<p><input type="checkbox" id="lightrr_meta_reviewon" name="lightrr_meta_reviewon" <?php checked($check_review_post, true); ?> />
<label for="lightrr_meta_reviewon"><?php esc_html_e('Review Post', 'lightrr') ?></label></p>

<div id="hidereview">

	<h3 class='hndle review-title'><span><?php esc_html_e('Review', 'lightrr') ?></span></h3>

	<p class="sec-rev"><label class="label-score" for="lightrr_meta_review_score"><?php esc_html_e('Overall Score', 'lightrr') ?></label>
	<input type="text" name="lightrr_meta_review_score" id="lightrr_meta_review_score" class="scorenumb" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_score', true) ); ?>" /></p>

	<p class="sec-rev"><label class="label-tag" for="lightrr_meta_review_title"><?php esc_html_e('Header Title', 'lightrr') ?></label>
	<input type="text" class="input-title" name="lightrr_meta_review_title" id="lightrr_meta_review_title" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_title', true) ); ?>" /></p>


	<div class="clearfix"></div>


	<p class="inside"><label class="label-summ" for="lightrr_meta_review_summ"><?php esc_html_e('Review Summary', 'lightrr') ?></label>
	<textarea name="lightrr_meta_review_summ" id="lightrr_meta_review_summ" rows="10" cols="40"><?php echo esc_textarea( get_post_meta($post->ID, 'lightrr_meta_review_summ', true) ); ?></textarea></p>

	<h3 class='hndle review-title'><span><?php esc_html_e('Criteria', 'lightrr') ?></span></h3>

	<p class="criter"><label class="screen-reader-texft" for="lightrr_meta_review_criterion_1"><?php esc_html_e('Criterion', 'lightrr') ?> 1</label>
	<input type="text" name="lightrr_meta_review_criterion_1" id="lightrr_meta_review_criterion_1" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_1', true ) ); ?>" />

	<label class="screen-reader-text" for="lightrr_meta_review_criterion_score_1"><?php esc_html_e('Criterion Score', 'lightrr') ?> 1</label>
	<input placeholder="<?php esc_html_e('Score Value', 'lightrr') ?>" class="input-sc scorenumb" type="text" name="lightrr_meta_review_criterion_score_1" id="lightrr_meta_review_criterion_score_1" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_score_1', true) ); ?>" /></p>

	<p class="criter"><label class="screen-reader-texft" for="lightrr_meta_review_criterion_2"><?php esc_html_e('Criterion', 'lightrr') ?> 2</label>
	<input type="text" name="lightrr_meta_review_criterion_2" id="lightrr_meta_review_criterion_2" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_2', true) ); ?>" />

	<label class="screen-reader-text" for="lightrr_meta_review_criterion_score_1"><?php esc_html_e('Criterion Score', 'lightrr') ?> 2</label>
	<input placeholder="<?php esc_html_e('Score Value', 'lightrr') ?>" class="input-sc scorenumb" type="text" name="lightrr_meta_review_criterion_score_2" id="lightrr_meta_review_criterion_score_2" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_score_2', true) ); ?>" /></p>

	<p class="criter"><label class="screen-reader-texft" for="lightrr_meta_review_criterion_3"><?php esc_html_e('Criterion', 'lightrr') ?> 3</label>
	<input type="text" name="lightrr_meta_review_criterion_3" id="lightrr_meta_review_criterion_3" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_3', true) ); ?>" />

	<label class="screen-reader-text" for="lightrr_meta_review_criterion_score_1"><?php esc_html_e('Criterion Score', 'lightrr') ?> 3</label>
	<input placeholder="<?php esc_html_e('Score Value', 'lightrr') ?>" class="input-sc scorenumb" type="text" name="lightrr_meta_review_criterion_score_3" id="lightrr_meta_review_criterion_score_3" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_score_3', true) ); ?>" /></p>

	<p class="criter"><label class="screen-reader-texft" for="lightrr_meta_review_criterion_4"><?php esc_html_e('Criterion', 'lightrr') ?> 4</label>
	<input type="text" name="lightrr_meta_review_criterion_4" id="lightrr_meta_review_criterion_4" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_4', true) ); ?>" />

	<label class="screen-reader-text" for="lightrr_meta_review_criterion_score_4"><?php esc_html_e('Criterion Score', 'lightrr') ?> 4</label>
	<input placeholder="<?php esc_html_e('Score Value', 'lightrr') ?>" class="input-sc scorenumb" type="text" name="lightrr_meta_review_criterion_score_4" id="lightrr_meta_review_criterion_score_4" value="<?php echo esc_attr( get_post_meta($post->ID, 'lightrr_meta_review_criterion_score_4', true) ); ?>" /></p>
	<div class="clearfix"></div>

</div>

	<?php
}

add_action('save_post', 'lightrr_meta_box_save');
function lightrr_meta_box_save($post_id) {
	global $post;
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
	if (!isset($_POST['meta_box_nonce']) || !wp_verify_nonce($_POST['meta_box_nonce'], 'lightrr_meta_box_nonce')) return;
	if (!current_user_can('edit_post', $post_id)) return;
	
	$me_fields = array('lightrr_meta_review_score', 'lightrr_meta_review_title', 'lightrr_meta_review_summ', 'lightrr_meta_review_criterion_1', 'lightrr_meta_review_criterion_score_1', 'lightrr_meta_review_criterion_2', 'lightrr_meta_review_criterion_score_2', 'lightrr_meta_review_criterion_3', 'lightrr_meta_review_criterion_score_3', 'lightrr_meta_review_criterion_4', 'lightrr_meta_review_criterion_score_4');
	
	$me_checks = array('lightrr_meta_featured_post', 'lightrr_meta_sidebar', 'lightrr_meta_reviewon',);
	
	foreach ($me_checks as $me_ck) {
		
		$me_meta = isset($_POST[$me_ck]) && !empty($_POST[$me_ck]) ? true : false;
		
		if (isset($_POST[$me_ck]) && !empty($_POST[$me_ck])) {
			update_post_meta($post_id, $me_ck, sanitize_text_field( $me_meta ) );
		} else {
			delete_post_meta($post_id, $me_ck);
		}

	}
	
	foreach ($me_fields as $me_fd) {
		$me_review = get_post_meta($post->ID, 'lightrr_meta_reviewon', true);
		if (isset($_POST[$me_fd]) && !empty($_POST[$me_fd])) {
			update_post_meta($post_id, $me_fd, sanitize_text_field( $_POST[$me_fd] ) );
		} else {
			delete_post_meta($post_id, $me_fd);
		}
	}
}

?>