<?php
/**
 * lightrr widgets
 *
 * @package lightrr
 * @since lightrr 1.0
 */
/* Custom Tags Widget
 =================================================================================================== */
class lightrr_tags_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_tags_lightrr',
			'description' => esc_html__("Display a cloud list of tags. Exclude and Include options.", 'lightrr')
		);
		parent::__construct('lightrr_tags_widget', esc_html__('/lightrr: Tag Cloud', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$tags_include = apply_filters('tags_include', $instance['tags_include']);
		$tags_exclude = apply_filters('tags_exclude', $instance['tags_exclude']);
		$tags_number = apply_filters('tags_number', $instance['tags_number']);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

<?php $argstags = array(
			'smallest' => 8,
			'largest' => 12,
			'unit' => 'pt',
			'number' => '' . $tags_number . '',
			'format' => 'list',
			'orderby' => 'name',
			'order' => 'ASC',
			'exclude' => '' . $tags_exclude . '',
			'include' => '' . $tags_include . '',
			'link' => 'view',
			'taxonomy' => 'post_tag',
			'echo' => true
		);
		wp_tag_cloud($argstags); ?>

	<?php echo $args['after_widget']; ?>  <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['tags_include'] = strip_tags($new_instance['tags_include']);
		$instance['tags_exclude'] = strip_tags($new_instance['tags_exclude']);
		$instance['tags_number'] = strip_tags($new_instance['tags_number']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$tags_include = isset($instance['tags_include']) ? $instance['tags_include'] : '';
		$tags_exclude = isset($instance['tags_exclude']) ? $instance['tags_exclude'] : '';
		$tags_number = isset($instance['tags_number']) ? absint($instance['tags_number']) : '18';
?>

<p><label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr($this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('tags_include') ); ?>"><strong>Include (Optional)</strong></label>
  <small>Comma separated list of tags IDs to only show those (Eg: 8,16,21).</small>
  <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('tags_include', 'lightrr') ); ?>" name="<?php echo esc_attr( $this->get_field_name('tags_include') ); ?>" type="text" value="<?php echo esc_attr($tags_include); ?>" /></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('tags_exclude') ); ?>"><strong>Exclude (Optional)</strong></label>  <small>Comma separated list of tags IDs to exclude. (Eg: 12,33). (Include must be empty).</small>
  <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('tags_exclude') ); ?>" name="<?php echo esc_attr( $this->get_field_name('tags_exclude') ); ?>" type="text" value="<?php echo esc_attr($tags_exclude); ?>" /></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('tags_number') ); ?>">How many tags to show (0 = Display all tags)</label> 
  <input id="<?php echo esc_attr( $this->get_field_id('tags_number') ); ?>" name="<?php echo esc_attr( $this->get_field_name('tags_number') ); ?>" type="number" min="0" max="50" value="<?php echo esc_attr($tags_number); ?>" /></p>

<?php
	}
}

function lightrr_tags_widgetInit() {
	register_widget('lightrr_tags_widget');
}
add_action('widgets_init', 'lightrr_tags_widgetInit');

/* Custom Categories Widget
 =================================================================================================== */
class lightrr_cats_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_cats_lightrr',
			'description' => esc_html__("Display a list of categories. Exclude and Include options.", 'lightrr')
		);
		parent::__construct('lightrr_cats_widget', esc_html__('/lightrr: Categories Cloud', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$cats_include = apply_filters('cats_include', $instance['cats_include']);
		$cats_exclude = apply_filters('cats_exclude', $instance['cats_exclude']);
		$cats_number = apply_filters('cats_number', $instance['cats_number']);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

  <ul><?php $argscats = array(
			'exclude' => '' . $cats_exclude . '',
			'include' => '' . $cats_include . '',
			'hierarchical' => 1,
			'title_li' => '',
			'show_option_none' => 'Null',
			'number' => '' . $cats_number . '',
			'echo' => 1,
			'depth' => 0,
			'current_category' => 0,
			'pad_counts' => 0,
			'taxonomy' => 'category',
			'walker' => null
		);
		
		wp_list_categories($argscats); ?></ul> 

<?php echo $args['after_widget']; ?>  <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['cats_include'] = strip_tags($new_instance['cats_include']);
		$instance['cats_exclude'] = strip_tags($new_instance['cats_exclude']);
		$instance['cats_number'] = strip_tags($new_instance['cats_number']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$cats_include = isset($instance['cats_include']) ? $instance['cats_include'] : '';
		$cats_exclude = isset($instance['cats_exclude']) ? $instance['cats_exclude'] : '';
		$cats_number = isset($instance['cats_number']) ? absint($instance['cats_number']) : '0';
?>

<p><label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('cats_include') ); ?>"><strong>Include (Optional)</strong></label>
  <small>Comma separated list of category IDs to only show those (Eg: 8,16,21).</small>
  <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('cats_include') ); ?>" name="<?php echo esc_attr( $this->get_field_name('cats_include') ); ?>" type="text" value="<?php echo esc_attr($cats_include); ?>" /></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('cats_exclude') ); ?>"><strong>Exclude (Optional)</strong></label>  <small>Comma separated list of category IDs to exclude. (Eg: 12,33). (Include must be empty).</small>
  <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('cats_exclude') ); ?>" name="<?php echo esc_attr( $this->get_field_name('cats_exclude') ); ?>" type="text" value="<?php echo esc_attr($cats_exclude); ?>" /></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('cats_number') ); ?>">How many categories to show (0 = Display all categories)</label> 
  <input id="<?php echo esc_attr( $this->get_field_id('cats_number') ); ?>" name="<?php echo esc_attr( $this->get_field_name('cats_number') ); ?>" type="number" min="0" max="50" value="<?php echo esc_attr($cats_number); ?>" /></p>

<?php
	}
}

function lightrr_cats_widgetInit() {
	register_widget('lightrr_cats_widget');
}
add_action('widgets_init', 'lightrr_cats_widgetInit');

/* Custom Tag Cloud Widget
 =================================================================================================== */

add_filter('widget_tag_cloud_args', 'lightrr_wp_tag_cloud');
function lightrr_wp_tag_cloud($argstags) {
	$argstags = array(
		'smallest' => 8,
		'largest' => 12,
		'format' => 'list'
	);
	return $argstags;
}

/* Social Icons Widget
 =================================================================================================== */
class lightrr_icons_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_icons',
			'description' => esc_html__("Display Social Icons", 'lightrr')
		);
		parent::__construct('lightrr_icons_widget', esc_html__('/lightrr: Social Icons', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

	<div class="lightrr__mini-icons"><?php lightrr_icons(); ?></div>

<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
?>

<p><label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

<?php
	}
}

function lightrr_icons_widgetInit() {
	register_widget('lightrr_icons_widget');
}
add_action('widgets_init', 'lightrr_icons_widgetInit');

/* List Authors Widgets
 =================================================================================================== */
class lightrr_authors_widget extends WP_Widget {
	function __construct() {
		
		$widget_ops = array(
			'classname' => 'widget_lightrr_authors',
			'description' => esc_html__("List Blog Editors with Avatar", 'lightrr')
		);
		parent::__construct('lightrr_authors_widget', esc_html__('/lightrr: List Authors', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>


	<ul class="lightrr__list-editors">
<?php
			$authors = array();
			$levels = array(
				'administrator',
				'editor',
				'author'
			);
			foreach ($levels as $level):
				$users_query = new WP_User_Query(array(
					'fields' => 'all_with_meta',
					'role' => $level,
					'orderby' => 'display_name'
				));
				$list = $users_query->get_results();
				if ($list) $authors = array_merge($authors, $list);
			endforeach;
			foreach ($authors as $author) {
				echo '<li class="tooltip_init"><a data-toggle="tooltip" data-placement="top" title="'.esc_attr(get_the_author_meta('display_name', $author->ID)).'" href="'.esc_url(get_author_posts_url( get_the_author_meta('ID', $author->ID) )).'">'.get_avatar($author->ID, 120).'</a></li>';
			}

?>
	</ul>

<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
?>

<p>
<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>

<?php
	}
}

function lightrr_authors_widgetInit() {
	register_widget('lightrr_authors_widget');
}
add_action('widgets_init', 'lightrr_authors_widgetInit');

/* Post from Category
 =================================================================================================== */
class lightrr_catposts_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_catposts',
			'description' => esc_html__("Display recent posts from category in a slider", 'lightrr')
		);
		parent::__construct('lightrr_catposts_widget', esc_html__('/lightrr: Posts Slider', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$postnumb = apply_filters('widget_postnumb', $instance['postnumb']);
		$nn_cat = apply_filters('widget_nn_cat', $instance['nn_cat']);
		
		$argsquery = array(
			'cat' => $nn_cat,
			'ignore_sticky_posts' => 1,
			'posts_per_page' => $postnumb,
		);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
		
		$wp_posts = new WP_Query($argsquery);
		if ($wp_posts->have_posts()):
?>


<div class="owl-carousel lightrr__widget-slider owl-theme">

 <?php while ($wp_posts->have_posts()):
				$wp_posts->the_post(); ?>

	<div class="item">
		<?php lightrr_data_over(false, true, true) ?>
	  <a href="<?php esc_url( the_permalink() ); ?>">
	  <?php lightrr_featured_thumb('lightrr_poster_l'); ?>
		<h2><?php the_title(); ?></h2></a>
	</div>

  <?php
			endwhile;
		endif;
		wp_reset_postdata(); ?>
 
</div>

<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['postnumb'] = strip_tags($new_instance['postnumb']);
		$instance['nn_cat'] = strip_tags($new_instance['nn_cat']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$postnumb = isset($instance['postnumb']) ? $instance['postnumb'] : '3';
		$nn_cat = isset($instance['nn_cat']) ? $instance['nn_cat'] : false;
?>
<p>
<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>
<p>
<label for="<?php echo esc_attr( $this->get_field_id('category') ); ?>"><?php esc_html_e("Category:", 'lightrr'); ?></label> 
<br />
	  <?php
		$category_args = array(
			'show_count' => 1,
			'hide_empty' => 0,
			'id' => $this->get_field_id('nn_cat') ,
			'class' => 'widefat',
			'name' => $this->get_field_name('nn_cat') ,
			'selected' => $nn_cat ? $nn_cat : false,
		);
		wp_dropdown_categories($category_args);
?>
</p>
<p>
<label for="<?php echo esc_attr( $this->get_field_id('postnumb') ); ?>"><?php esc_html_e("Number of posts:", 'lightrr'); ?></label> 
<input id="<?php echo esc_attr( $this->get_field_id('postnumb') ); ?>" name="<?php echo esc_attr( $this->get_field_name('postnumb') ); ?>" type="number" min="0" max="10" value="<?php echo esc_attr($postnumb); ?>" />
</p>
<p>

<input type="hidden" id="sideFeature-Submit" name="sideFeature-Submit" value="1" />

</p>

<?php
	}
}

function lightrr_catposts_widgetInit() {
	register_widget('lightrr_catposts_widget');
}
add_action('widgets_init', 'lightrr_catposts_widgetInit');


/* Facebook Like Box widget
 =================================================================================================== */

class lightrr_fblike_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_fblike',
			'description' => esc_html__("Add a Facebook Page Plugin", 'lightrr')
		);
		parent::__construct('lightrr_fblike_widget', esc_html__('/lightrr: Facebook Page Plugin', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$fburl = apply_filters('fburl', $instance['fburl']);
		$fbstream = isset($instance['fbstream']) ? apply_filters('fbstream', $instance['fbstream']) : 0;

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

<div class="fb-page" data-href="<?php echo esc_url($fburl); ?>" data-width="500" data-hide-cover="false" data-show-facepile="true" data-adapt-container-width="true" data-show-posts="<?php if ($fbstream) { echo "true"; } ?>"></div>

<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['fburl'] = strip_tags($new_instance['fburl']);
		$instance['fbstream'] = strip_tags($new_instance['fbstream']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$fburl = isset($instance['fburl']) ? $instance['fburl'] : '';
		$fbstream = isset($instance['fbstream']) ? $instance['fbstream'] : 0;
?>

<p>
<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>
<p>
  <label for="<?php echo esc_attr( $this->get_field_id('fburl') ); ?>">Facebook Page URL</label> 
  <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('fburl') ); ?>" name="<?php echo esc_attr( $this->get_field_name('fburl') ); ?>" type="text" value="<?php echo esc_url($fburl); ?>" />
</p>

<p>
<label for="<?php echo esc_attr( $this->get_field_id('fbstream') ); ?>"><?php esc_html_e('Show posts', 'lightrr') ?></label>
<input type="checkbox" id="<?php echo esc_attr( $this->get_field_id('fbstream') ); ?>" name="<?php echo esc_attr( $this->get_field_name('fbstream') ); ?>" value="1" <?php checked(esc_attr($fbstream), true); ?> />
</p>

<?php
	}
}

function lightrr_fblike_widgetInit() {
	register_widget('lightrr_fblike_widget');
}
add_action('widgets_init', 'lightrr_fblike_widgetInit');

/* Recent Comments Widget
 =================================================================================================== */

class lightrr_recentcomms_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_recentcomms',
			'description' => esc_html__("Display recent comments with author gravatar", 'lightrr')
		);
		parent::__construct('lightrr_recentcomms_widget', esc_html__('/lightrr: Recent Comments w/Avatar', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$commnumb = apply_filters('widget_commnumb', $instance['commnumb']);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

			  <ul>
<?php $comments = get_comments('status=approve&number=' . $commnumb . ''); ?>
<?php foreach ($comments as $comment) { ?>
				<li><a class="author-av" href="<?php echo esc_url ( get_permalink($comment->comment_post_ID) . '#comment-' . $comment->comment_ID ); ?>"><?php echo get_avatar($comment, '100'); ?></a>

				  <p class="comment-text"><strong><?php echo strip_tags($comment->comment_author); ?>:</strong> <a href="<?php echo esc_url(get_permalink($comment->comment_post_ID) . '#comment-' . $comment->comment_ID) ?>"><?php echo wp_html_excerpt($comment->comment_content, 60); ?>...</a></p>
				</li> 
<?php
		} ?>
			  </ul>
<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['commnumb'] = strip_tags($new_instance['commnumb']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$commnumb = isset($instance['commnumb']) ? $instance['commnumb'] : '5';
?>

<p>
<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>
<p>
<label for="<?php echo esc_attr( $this->get_field_id('commnumb') ); ?>"><?php esc_html_e("Number of comments:", 'lightrr'); ?></label> 
<input id="<?php echo esc_attr( $this->get_field_id('commnumb') ); ?>" name="<?php echo esc_attr( $this->get_field_name('commnumb') ); ?>" type="number" value="<?php echo esc_attr($commnumb); ?>" />
</p>
<?php
	}
}

function lightrr_recentcomms_widgetInit() {
	register_widget('lightrr_recentcomms_widget');
}
add_action('widgets_init', 'lightrr_recentcomms_widgetInit');



/* Most Popular Widget
 =================================================================================================== */
class lightrr_mostpop_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_popular_posts',
			'description' => esc_html__("Display popular posts based on comments or views", 'lightrr')
		);
		parent::__construct('lightrr_mostpop_widget', esc_html__('/lightrr: Popular Posts', 'lightrr') , $widget_ops);
	}
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$postbase = apply_filters('widget_postbase', $instance['postbase']);
		$postperiod = apply_filters('widget_postperiod', $instance['postperiod']);
		$postnumb = apply_filters('widget_postnumb', $instance['postnumb']);

		$argsquery = array(
			'ignore_sticky_posts' => 1,
			'year' => ('month' == $postperiod || 'week' == $postperiod) ? date('Y') : false,
			'monthnum' => ('month' == $postperiod) ? date('m') : false,
			'w' => ('week' == $postperiod) ? date('W')-1 : false,
			'posts_per_page' => $postnumb,
			'meta_key' => ('views' == $postbase) ? 'post_views_count' : false,
			'orderby' => ('views' == $postbase) ? 'meta_value_num' : 'comment_count',
		);

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>


<ul>
<?php $count = 0; $wp_posts = new WP_Query($argsquery);
	if ($wp_posts->have_posts()) :
		while ($wp_posts->have_posts()):
			$wp_posts->the_post();
		$count++;
?>

	<li class="popular_list<?php if (1 == $count) { echo "_top transform-fx"; } ?>">


		<?php if ( 1 == $count ) { ?>

		<div class="lightrr__img-container"><?php lightrr_featured_thumb('lightrr_main_feed'); ?></div>

		<a href="<?php esc_url( the_permalink() ); ?>"><div class="lightrr__chroma"></div></a>

		<?php } else { lightrr_featured_thumb('thumbnail'); } ?>

		<div class="lightrr__item-insider">
		<?php if ($postbase == "comments") { lightrr_comments_nb('meta-com'); } else { echo '<a title="'.esc_html__('Total Views', 'lightrr').'" class="meta-count lightrr__icon-fire" href=" ' . esc_url ( get_permalink() ) . '  "> ' . lightrr_getPostViews(get_the_ID()) . '</a>'; } ?>
		<?php if (1 !== $count) { ?> <div class="meta-cat"><?php the_category( ' ' ); ?></div> <?php } ?>
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		</div>
	</li>


<?php endwhile; endif; wp_reset_postdata(); ?>
</ul>

<?php echo $args['after_widget']; ?> 
<?php }
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['postbase'] = strip_tags($new_instance['postbase']);
		$instance['postperiod'] = strip_tags($new_instance['postperiod']);
		$instance['postnumb'] = strip_tags($new_instance['postnumb']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$postbase = isset($instance['postbase']) ? $instance['postbase'] : '';
		$postperiod = isset($instance['postperiod']) ? $instance['postperiod'] : '';
		$postnumb = isset($instance['postnumb']) ? $instance['postnumb'] : '3';
?>

<p><label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
<p><label for="<?php echo esc_attr( $this->get_field_id('postnumb') ); ?>"><?php esc_html_e("Number of posts:", 'lightrr'); ?></label> 
<input id="<?php echo esc_attr( $this->get_field_id('postnumb') ); ?>" name="<?php echo esc_attr( $this->get_field_name('postnumb') ); ?>" type="number" min="0" max="10" value="<?php echo esc_attr($postnumb); ?>" /></p>
<p><label for="<?php echo esc_attr( $this->get_field_id('postbase') ); ?>"><?php esc_html_e("Filter by:", 'lightrr'); ?></label> 
<select name="<?php echo esc_attr( $this->get_field_name('postbase') ); ?>" id="<?php echo esc_attr( $this->get_field_id('postbase') ); ?>" class="widefat">
<?php
$options = array(
	'comments' => esc_html__('Post Comments', 'lightrr'),
	'views' => esc_html__('Post Views', 'lightrr')
	);
foreach ($options as $key => $option) {
	echo '<option value="' . esc_attr( $key ) . '" id="postbase"', $postbase == $key ? ' selected="selected"' : '', '>', esc_html( $option ), '</option>';
}
?>

</select></p>

<p><label for="<?php echo esc_attr( $this->get_field_id('postperiod') ); ?>"><?php esc_html_e("Published:", 'lightrr'); ?></label> 
<select name="<?php echo esc_attr( $this->get_field_name('postperiod') ); ?>" id="<?php echo esc_attr( $this->get_field_id('postperiod') ); ?>" class="widefat">
<?php
$options = array(
	'alltime' => esc_html__('All Time', 'lightrr'),
	'month' => esc_html__('Current Month', 'lightrr'),
	'week' => esc_html__('Last Week', 'lightrr')
	);
foreach ($options as $key => $option) {
	echo '<option value="' . esc_attr( $key ) . '" id="postperiod"', $postperiod == $key ? ' selected="selected"' : '', '>', esc_html( $option ), '</option>';
}
?>
</select></p>

<?php } 
}

function lightrr_mostpop_widgetInit() {
	register_widget('lightrr_mostpop_widget');
}
add_action('widgets_init', 'lightrr_mostpop_widgetInit');

/* Latest Posts Widget
 =================================================================================================== */

class lightrr_latest_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_latestposts',
			'description' => esc_html__("Display recent posts with thumbnail", 'lightrr')
		);
		parent::__construct('lightrr_latest_widget', esc_html__('/lightrr: Latest Posts', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$postnumb = apply_filters('widget_postnumb', $instance['postnumb']);
		
		$argsquery = array(
			'ignore_sticky_posts' => 1,
			'posts_per_page' => $postnumb
		);
		
		$wp_posts = new WP_Query($argsquery);
		if ($wp_posts->have_posts()):

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

<ul>
  <?php while ($wp_posts->have_posts()):
				$wp_posts->the_post(); ?>
<li class="list-round">
	<?php lightrr_featured_thumb('thumbnail'); ?> 

	<div class="li-content cell"><a href="<?php esc_url(the_permalink()) ?>" rel="bookmark" title="<?php printf(esc_html__('Permalink to %s', 'lightrr') , the_title_attribute('echo=0')); ?>"><?php the_title(); ?></a> 
	  <div class="meta-wg"><time class="meta-date lightrr__icon-date" datetime="<?php esc_attr (the_time( get_option( 'time_format' )) ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time> <?php lightrr_comments_nb('comments-meta'); ?></div>
	</div>
</li> 
  <?php endwhile; endif; wp_reset_postdata(); ?>
</ul>

<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['postnumb'] = strip_tags($new_instance['postnumb']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$postnumb = isset($instance['postnumb']) ? $instance['postnumb'] : '3';
?>

<p>
<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>
<p>
<label for="<?php echo esc_attr( $this->get_field_id('postnumb') ); ?>"><?php esc_html_e("Number of posts:", 'lightrr'); ?></label> 
<input id="<?php echo esc_attr( $this->get_field_id('postnumb') ); ?>" name="<?php echo esc_attr( $this->get_field_name('postnumb') ); ?>" type="number" value="<?php echo esc_attr($postnumb); ?>" />
</p>
<?php
	}
}

function lightrr_latest_widgetInit() {
	register_widget('lightrr_latest_widget');
}
add_action('widgets_init', 'lightrr_latest_widgetInit');

/* Embed Widget
 =================================================================================================== */
 
class lightrr_video_widget extends WP_Widget {
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_lightrr_video',
			'description' => esc_html__("Embed a media object (YouTube, Vimeo, Soundcloud)", 'lightrr')
		);
		parent::__construct('widget_lightrr_video', esc_html__('/lightrr: Embed Media', 'lightrr') , $widget_ops);
	}
	/** Widget Content */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$embed = apply_filters('embed', $instance['embed']);
		$mediatype = empty( $instance['mediatype'] ) ? '' : $instance['mediatype'];

		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
?>

			<?php
			if ('video' == $mediatype && !empty($embed)) {
				echo '<div class="lightrr__video-in embed-responsive embed-responsive-16by9">' . wp_oembed_get( esc_url($embed), array('width'=>720) ) . '</div>';
			}
			else if (!empty($embed)){
				echo wp_oembed_get( esc_url($embed), array('width'=>720) );
			}
			?>
<?php echo $args['after_widget']; ?> <?php
	}
	/** WP_Widget Update */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['embed'] = strip_tags($new_instance['embed']);
		$instance['mediatype'] = strip_tags($new_instance['mediatype']);
		return $new_instance;
	}
	
	function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$embed = isset($instance['embed']) ? $instance['embed'] : '';
		$mediatype = isset($instance['mediatype']) ? $instance['mediatype'] : '';
?>

<p>
<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', 'lightrr'); ?></label> 
<input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
</p>
<p><label for="<?php echo esc_attr( $this->get_field_id('mediatype') ); ?>"><?php esc_html_e("Media Type:", 'lightrr'); ?></label> 
<select name="<?php echo esc_attr( $this->get_field_name('mediatype') ); ?>" id="<?php echo esc_attr( $this->get_field_id('mediatype') ); ?>" class="widefat">
<?php
$options = array(
	'video' => esc_html__('Video (YouTube, Vimeo)', 'lightrr'),
	'other' => esc_html__('Other', 'lightrr')
	);
foreach ($options as $key => $option) {
	echo '<option value="' . esc_attr( $key ) . '" id="mediatype"', $mediatype == $key ? ' selected="selected"' : '', '>', esc_html( $option ), '</option>';
}
?>
</select></p>
<p>
  <label for="<?php echo esc_attr( $this->get_field_id('embed') ); ?>">Media URL</label> 
  <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('embed') ); ?>" name="<?php echo esc_attr( $this->get_field_name('embed') ); ?>" type="text" value="<?php echo esc_attr($embed); ?>" />
</p>
<?php
	}
}

function lightrr_video_widgetInit() {
	register_widget('lightrr_video_widget');
}
add_action('widgets_init', 'lightrr_video_widgetInit');


/* Co Widget
 =================================================================================================== */
if (!class_exists('CS_Widget')) {
	class CS_Widget extends WP_Widget
	{
		
		function __construct() {
			
			$widget_ops = array(
				'classname' => 'cs_widget_example',
				'description' => esc_html__('Upload a Image Banner or paste AdSense Code', 'lightrr')
			);
			
			parent::__construct('cs_widget', esc_html__('/lightrr: Advertising', 'lightrr') , $widget_ops);
		}
		
		function widget($args, $instance) {

			extract($args);

			$cs_custom_allowedtag = array( 
					'script' => array( 
						'type' => array(),
						'src' => array(),
						'class' => array(),
						'async' => array(),
						'data-id' => array(),
						'data-format' => array()
					),
					'ins' => array( 
						'class' => array(),
						'style' => array(),
						'data-ad-client' => array(),
						'data-ad-slot' => array(),
						'data-ad-format' => array()
					)
			);

			$adcode = $instance['adcode'];

			echo $args['before_widget'];
			if ( ! empty( $instance['title'] ) ) {
				echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
			}
?>

			 <?php
			if ($instance['adimg']): ?>
			 <div class="single-bb">
				<a href="<?php
				echo esc_url($instance['adlink']); ?>" target="_blank"><img src="<?php
				echo esc_url($instance['adimg']); ?>" alt="<?php
				echo esc_attr($instance['title']); ?>" /></a>
			 </div>
			 <?php
			endif; ?>

			 <?php
			if ($instance['adcode']): ?>
			<div class="bnr-section">
				<?php echo wp_kses( $adcode, $cs_custom_allowedtag); ?>
			</div>
		<?php
			endif; ?>


			<?php echo $args['after_widget'];
		}
		
		function update($new_instance, $old_instance) {
			
			$allowed_tags = array(
				"ins" => array(
					"style" => array() ,
					"class" => array() ,
					"data-ad-client" => array() ,
					"data-ad-slot" => array() ,
					"data-ad-format" => array() ,
				) ,
				"script" => array(
					"async" => array() ,
					"src" => array() ,
					"type" => array() ,
					"data-id" => array() ,
					"data-format" => array() ,
				)
			);
			
			$instance = $old_instance;
			$instance['title'] = esc_attr($new_instance['title']);
			$instance['adimg'] = esc_attr($new_instance['adimg']);
			$instance['adlink'] = esc_attr($new_instance['adlink']);
			$instance['adcode'] = wp_kses($new_instance['adcode'], $allowed_tags);
			
			return $instance;
		}

		function form($instance) {

			//
			// set defaults
			// -------------------------------------------------
			$instance = wp_parse_args($instance, array(
				'title' => '',
				'adimg' => '',
				'adlink' => '',
				'adcode' => '',
			));
			
			//
			// text field example
			// -------------------------------------------------
			$text_value = esc_attr($instance['title']);
			$text_field = array(
				'id' => $this->get_field_name('title') ,
				'name' => $this->get_field_name('title') ,
				'type' => 'text',
				'title' => 'Title',
			);

			if ( function_exists( 'cs_add_element' ) ) {
				echo cs_add_element( $text_field, $text_value );
			}
			
			//
			// upload field example
			// -------------------------------------------------
			$upload_value = esc_attr($instance['adimg']);
			$upload_field = array(
				'id' => $this->get_field_name('adimg') ,
				'name' => $this->get_field_name('adimg') ,
				'type' => 'upload',
				'title' => 'Ad Image Location',
				'desc' => '',
			);
			
			if ( function_exists( 'cs_add_element' ) ) {
				echo cs_add_element( $upload_field, $upload_value );
			}
			
			//
			// textarea field example
			// ------------------------adlink---adcode----------------------
			$adlink_value = esc_attr($instance['adlink']);
			$adlink_field = array(
				'id' => $this->get_field_name('adlink') ,
				'name' => $this->get_field_name('adlink') ,
				'type' => 'text',
				'title' => 'Ad Link Destination',
				'info' => '',
			);
			
			if ( function_exists( 'cs_add_element' ) ) {
				echo cs_add_element( $adlink_field, $adlink_value );
			}
			
			//
			// textarea field example
			// ---------------------------adcode----------------------
			$textarea_value = esc_attr($instance['adcode']);
			$textarea_field = array(
				'id' => $this->get_field_name('adcode') ,
				'name' => $this->get_field_name('adcode') ,
				'type' => 'textarea',
				'title' => 'AdSense Code',
				'info' => 'Paste here your code',
			);

			if ( function_exists( 'cs_add_element' ) ) {
				echo cs_add_element( $textarea_field, $textarea_value );
			}
		}
	}
}

if (!function_exists('cs_widget_init')) {
	function cs_widget_init() {
		register_widget('CS_Widget');
	}
	add_action('widgets_init', 'cs_widget_init', 2);
}