<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 * Template Name: Nosotros
 */
get_header();
get_template_part('content', 'subheader');
?>


<section class="lightrr__nos1">
   <div class="container">
      <div class="row">
         <div class="col-md-6">
            <div class="lightrr__nos1--media">
               <img src="<?php echo get_template_directory_uri();?>/img/img--somos.jpg">
            </div>
         </div>
         <div class="col-md-6">
            <div class="lightrr__nos1--title">
               <h3>¿Quiénes somos?</h3>
            </div>
            <div class="lightrr__nos1--desc">
               <p>Somos una empresa que ofrece diferentes programas de financiamiento así como <strong>créditos personales y créditos para pequeñas y medianas empresas</strong>, arrendamiento y factoraje financiero.</p>
            </div>
         </div>
      </div>
   </div>
</section>


<section class="lightrr__nos2">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <div class="lightrr__nos2--media">
               <img src="<?php echo get_template_directory_uri();?>/img/nosotros--compromiso.png">
            </div>
            <div class="lightrr__nos2--logo">
               <img src="<?php echo get_template_directory_uri(); ?>/img/fiar--logo.png" />
            </div>
         </div>
      </div>
   </div>
</section>


<section class="lightrr__nos3">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <div class="lightrr__nos3--title">
               <h3>Préstamos a tu medida</h3>
            </div>
            <div class="lightrr__nos3--media">
               <img src="<?php echo get_template_directory_uri();?>/img/nosotros--beneficios.png">
            </div>
         </div>
      </div>
   </div>
</section>

<section class="lightrr__nos4 wow fadeIn">
   <div class="container">
      <div class="d-flex align-content-center row">
         <div class="lightrr__nos4--media">
            <img src="<?php echo get_template_directory_uri();?>/img/img--misionv.jpg">
         </div>
      </div>
   </div>
</section>

<section class="lightrr__nos5">
   <div class="lightrr__nos5--item" style="background-image:url('<?php echo get_template_directory_uri() ?>/img/banner--prestamos.jpg');">
		<div class="container">
			<div class="row">
				<div class="lightrr__nos5--teaser">
					<h2>Te prestamos dinero para<br /> lo que necesites</h2>
					<div class="lightrr__nos5--btn">
						<a href="<?php echo get_home_url(); ?>/solicitud" target="_blank">Solicita tu crédito</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>


<section class="lightrr__nos6">
   <div class="container">
      <div class="row">
         <div class="col-md-12">
            <div class="lightrr__nos6--title">
               <h3>Valores</h3>
            </div>
            <div class="lightrr__nos6--media">
               <img src="<?php echo get_template_directory_uri();?>/img/img--valores.png">
            </div>
         </div>
      </div>
   </div>
</section>

<?php get_footer(); ?>
