<?php

// framework options filter example
function lightrr_cs_framework_options($options) {

	// Default homepage modules
	$default_modules = array(
		'disabled' => array(
			'content-featured-area-1' => 'Featured Posts 1',
			'content-featured-area-2' => 'Featured Posts 2',
			'content-featured-area-3' => 'Featured Posts 3',
			'content-featured-area-4' => 'Featured Posts 4',
			'content-featured-area-5' => 'Featured Posts 5',
			'content-banner' => 'Advertising',
		) ,
		'enabled' => array(
			'content-latest' => 'Latest Posts + Sidebar',
		) ,
	);

	$options_format_posts = array(
		'standard' => esc_html__('All Posts', 'lightrr') ,
		'featured' => esc_html__('Featured Posts', 'lightrr') ,
		'reviews' => esc_html__('Reviews', 'lightrr') ,
		'video' => esc_html__('Video', 'lightrr') ,
		'gallery' => esc_html__('Gallery', 'lightrr') ,
		'audio' => esc_html__('Audio', 'lightrr')
	);

	$options_idioma = array(
		'espanol' => esc_html__('Español', 'lightrr') ,
		'ingles' => esc_html__('Inglés', 'lightrr') ,
	);

	// Pull all categories into an array
	$options_categories = array();
	$options_categories[] = 'All Categories';
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}

	$imagepath = get_template_directory_uri() . '/img/';
	
	$options = array();
	
	/* General Options
	 =================================================================================================== */
	
	$options[] = array(
		'name' => 'general',
		'title' => esc_html__('General', 'lightrr') ,
		'icon' => 'fa fa-sliders',
		
		// begin: fields
		'fields' => array(
			array(
				'type' => 'subheading',
				'content' => esc_html__('General', 'lightrr') ,
			) ,
			array(
				'id' => 'idioma',
				'type' => 'select',
				'title' => esc_html__('Idioma', 'lightrr') ,
				'options'        => $options_idioma,
				'default_option' => 'Selecciona idioma'
			) ,
			array(
				'id' => 'logo_menu',
				'type' => 'textarea',
				'title' => esc_html__('Logo Menú (SVG)', 'lightrr') ,
			) ,
			array(
				'id' => 'logo_top',
				'type' => 'textarea',
				'title' => esc_html__('Logo Header (SVG)', 'lightrr') ,
			) ,
			array(
				'id' => 'footer_tagline',
				'type' => 'text',
				'title' => esc_html__('Footer Tagline', 'lightrr') ,
			) ,
		) ,
		
		// end: fields
	);




	/* Datos Options
	 =================================================================================================== */
	
	$options[] = array(
		'name' => 'datos',
		'title' => esc_html__('Datos', 'lightrr') ,
		'icon' => 'fa fa-street-view',
		
		// begin: fields
		'fields' => array(
			array(
				'type' => 'subheading',
				'content' => esc_html__('Datos', 'lightrr') ,
			) ,

			array(
				'id' => 'direccion',
				'type' => 'textarea',
				'title' => esc_html__('Dirección', 'lightrr') ,
			) ,
			array(
				'id' => 'correo',
				'type' => 'text',
				'title' => esc_html__('Correo electrónico', 'lightrr') ,
			) ,
			array(
				'id' => 'telefono',
				'type' => 'text',
				'title' => esc_html__('Teléfono', 'lightrr') ,
			) ,
			array(
				'id' => 'privacidad',
				'type' => 'select',
				'title' => esc_html__('Aviso de privacidad', 'lightrr') ,
				'options'        => 'pages',
				'default_option' => 'Seleccionar página'
			) ,

		),

	);



	/* Datos Options
	 =================================================================================================== */
	
	$options[] = array(
		'name' => 'social',
		'title' => esc_html__('Social', 'lightrr') ,
		'icon' => 'fa fa-share-alt',
		
		// begin: fields
		'fields' => array(
			array(
				'type' => 'subheading',
				'content' => esc_html__('Enlaces sociales', 'lightrr') ,
			) ,

					array(
						'id' => 'twitter_id',
						'type' => 'text',
						'title' => 'Twitter',
						'default' => '',
						'after' => '<i class="cs-text-muted">' . esc_html__('Twitter URL', 'lightrr') . '</i>',
					) ,

					array(
						'id' => 'facebook_id',
						'type' => 'text',
						'default' => '#',
						'title' => 'Facebook',
						'after' => '<i class="cs-text-muted">' . esc_html__('Facebook URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'instagram_id',
						'type' => 'text',
						'title' => 'Instagram',
						'default' => '#',
						'after' => '<i class="cs-text-muted">' . esc_html__('Instagram URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'gplus_id',
						'type' => 'text',
						'title' => 'Google Plus',
						'after' => '<i class="cs-text-muted">' . esc_html__('Google URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'soundcloud_id',
						'type' => 'text',
						'title' => 'Soundcloud',
						'default' => '',
						'after' => '<i class="cs-text-muted">' . esc_html__('Soundcloud URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'pinterest_id',
						'type' => 'text',
						'title' => 'Pinterest',
						'after' => '<i class="cs-text-muted">' . esc_html__('Pinterest URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'youtube_id',
						'type' => 'text',
						'title' => 'YouTube',
						'after' => '<i class="cs-text-muted">' . esc_html__('YouTube URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'vimeo_id',
						'type' => 'text',
						'title' => 'Vimeo',
						'default' => '',
						'after' => '<i class="cs-text-muted">' . esc_html__('Vimeo URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'tumblr_id',
						'type' => 'text',
						'title' => 'Tumblr',
						'after' => '<i class="cs-text-muted">' . esc_html__('Tumblr URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'twitch_id',
						'type' => 'text',
						'title' => 'Twitch',
						'default' => '',
						'after' => '<i class="cs-text-muted">' . esc_html__('Twitch URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'steam_id',
						'type' => 'text',
						'title' => 'Steam',
						'after' => '<i class="cs-text-muted">' . esc_html__('Steam URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'linkedin_id',
						'type' => 'text',
						'title' => 'LinkedIn',
						'after' => '<i class="cs-text-muted">' . esc_html__('LinkedIn URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'vk_id',
						'type' => 'text',
						'title' => 'VK',
						'after' => '<i class="cs-text-muted">' . esc_html__('VK URL', 'lightrr') . '</i>',
					) ,
					array(
						'id' => 'feed_id',
						'type' => 'text',
						'title' => 'Feed',
						'after' => '<i class="cs-text-muted">' . esc_html__('Feed URL', 'lightrr') . '</i>',
					) ,

		),

	);




	
	
	return $options;
}
add_filter('cs_framework_options', 'lightrr_cs_framework_options');
