<?php
/**
 * lightrr functions and definitions
 *
 * @package lightrr
 * @since lightrr 1.0
 */

/* Setup
 =================================================================================================== */
require_once get_template_directory() . '/inc/admin/cs-framework/cs-framework.php'; //Options Framework
define( 'CS_ACTIVE_FRAMEWORK',  true  );

if (is_admin() && isset($_GET['activated']) && $pagenow == "themes.php") {
	header('Location: ' . esc_url( admin_url('admin.php?page=cs-framework') ) );
}

if (!function_exists('lightrr_setup')):
	function lightrr_setup() {
		// Translation
		load_theme_textdomain( 'lightrr', get_template_directory() . '/languages' );

		// Supported functions
		if (function_exists('add_theme_support')) {
			add_theme_support('post-thumbnails'); // Post Thumbnails
			add_theme_support('menus'); // Menus
			add_theme_support('post-formats', array('gallery','video','audio')); // Posts Formats
			add_theme_support('title-tag'); // Title tag
			add_theme_support('automatic-feed-links'); 	// Add posts and comments RSS feed links to head
			add_theme_support('html5', array('search-form','comment-form','comment-list','gallery','caption') );
		}
		// Register Menus
		register_nav_menus(array('lightrr__principal-menu' => esc_html__('Menú principal', 'lightrr') ));
		register_nav_menus(array('lightrr__principal-inferior-menu' => esc_html__('Menú principal inferior', 'lightrr') ));
	}
endif; // lightrr_setup
add_action('after_setup_theme', 'lightrr_setup');

function lightrr_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'lightrr_content_width', 750 );
}
add_action( 'after_setup_theme', 'lightrr_content_width', 0 );

// IMG Thumbnails
add_image_size('lightrr_single_media', 905, 500, true); // Single Post
add_image_size('lightrr_single_gallery', 300, 270, true); // Single Post
add_image_size('lightrr_single_related', 500, 340, true); // Single Related

add_image_size('lightrr_feed', 400, 240, true); // Archive


/* Register widgetized area
 =================================================================================================== */

// function lightrr_widgets_init() {
// 	$widgetized_areas = array(
// 		'lightrr__sidebar' => esc_html__('Sidebar (Default for all Pages)', 'lightrr') ,
// 		'lightrr__single-post-sidebar' => esc_html__('Single Posts Sidebar', 'lightrr') ,
// 		'lightrr__page-sidebar' => esc_html__('Pages Sidebar', 'lightrr') ,
// 		'lightrr__blog-sidebar' => esc_html__('Blog Sidebar', 'lightrr') ,
// 		'lightrr__contact-sidebar' => esc_html__('Contact Page Sidebar', 'lightrr') ,
// 		'lightrr__footer-1' => esc_html__('Footer First-Column', 'lightrr') ,
// 		'lightrr__footer-2' => esc_html__('Footer Second-Column', 'lightrr') ,
// 		'lightrr__footer-3' => esc_html__('Footer Third-Column', 'lightrr') ,
// 	);

// 	foreach ($widgetized_areas as $item => $value) {
// 		register_sidebar(array(
// 			'name' => $value,
// 			'id' => $item,
// 			'before_widget' => '<div id="%1$s" class="lightrr__widget lightrr__wow-fade %2$s">',
// 			'after_widget' => '</div>',
// 			'before_title' => '<h3 class="lightrr__section-title"><span>',
// 			'after_title' => '</span></h3>',
// 		));
// 	}
// }
// add_action('widgets_init', 'lightrr_widgets_init');

/* Load scripts and styles
 =================================================================================================== */

function lightrr_fonts_url() {
	$fonts_url = '';
	$fonts = array();
	$subsets = 'latin,latin-ext';

	$fonts[] = 'Lato:100,300,400,500,700,900,100italic,300italic,400italic,500italic,700italic,900italic';

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}

	return esc_url( $fonts_url );
}

function lightrr_scripts() {
	$lightrr_data = wp_get_theme();
	$lightrr_ver =date("H:i:s");
	/* * Load Fonts */
	//wp_enqueue_style( 'lightrr__fonts', esc_url( lightrr_fonts_url() ), array() );
	wp_enqueue_style('lightrr__app', get_template_directory_uri() . '/app/build/css/app.css', array() , esc_attr( $lightrr_ver ), 'all');
	/* * Load Javascript */
	wp_enqueue_script('lightrr__library', get_template_directory_uri() . '/app/build/js/lib.js', array('jquery') , esc_attr( $lightrr_ver ), true);
	wp_enqueue_script('lightrr__init', get_template_directory_uri() . '/app/build/js/init.js', array('jquery') , esc_attr( $lightrr_ver ), true);
}
add_action('wp_enqueue_scripts', 'lightrr_scripts');


/* oembed Filter
 =================================================================================================== */

function lightrr_custom_oembed_filter($html, $url, $attr, $post_ID) {

	if (preg_match('/youtube\.com\/watch/i', $url) || preg_match('/vimeo\.com/i', $url)) {
		$return = '<div class="lightrr__video-in embed-responsive embed-responsive-16by9">'.$html.'</div>';
	}
	else if (preg_match('/soundcloud\.com/i', $url)) {
		$return = '<div class="lightrr__embed-media lightrr__embed-sound">'.$html.'</div>';
	}
	else{
		$return = '<div class="lightrr__embed-media">'.$html.'</div>';
	}
	return $return;
}
add_filter( 'embed_oembed_html', 'lightrr_custom_oembed_filter', 10, 4 );


/* SVG upload
 =================================================================================================== */

function ui_mime_types( $mimes = array() ) {
	if ( current_user_can( 'administrator' ) ) {
		$mimes['svg'] = 'image/svg+xml';
		$mimes['svgz'] = 'image/svg+xml';
		return $mimes;
	} else {
		return $mimes;
	}
}
add_filter( 'upload_mimes', 'ui_mime_types' );


/* Register custom post type
 =================================================================================================== */

function studiod_custom_post_type() {
	register_post_type( 'lightrr_proyecto',
		array(
			'labels' => array(
				'name' => esc_html__( 'Proyectos', 'studiod') ,
				'singular_name' => esc_html__( 'Proyecto', 'studiod') ,
				),
			'public' => true,
			'has_archive' => true,
			'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'author' ),
			'menu_position' => 5,
			'menu_icon' => 'dashicons-format-video',
			'rewrite' => array( 'slug' => 'proyecto','with_front' => false ),
			)
		);
}
add_action( 'init', 'studiod_custom_post_type' );

function create_media_category_tax() {
	register_taxonomy(
		'media_category',
		'lightrr_proyecto',
		array(
			'label' => __( 'Categoría' ),
			'rewrite' => array( 'slug' => 'media_category' ),
			'hierarchical' => true,
		)
	);
}
add_action( 'init', 'create_media_category_tax' );


/* Exclude pages from WordPress Search
 =================================================================================================== */

if (!is_admin()) {
	function wpb_search_filter($query) {
		if ($query->is_search) {
			$query->set('post_type', 'lightrr_proyecto');
		}
		return $query;
	}
	add_filter('pre_get_posts','wpb_search_filter');
}

/* Custom excerptcontent
 =================================================================================================== */

 class Excerpt {

  // Default length (by WordPress)
  public static $length = 55;

  // So you can call: my_excerpt('short');
  public static $types = array(
      'short' => 25,
      'regular' => 55,
      'long' => 100
    );

  /**
   * Sets the length for the excerpt,
   * then it adds the WP filter
   * And automatically calls the_excerpt();
   *
   * @param string $new_length
   * @return void
   * @author Baylor Rae'
   */
  public static function length($new_length = 55) {
    Excerpt::$length = $new_length;

    add_filter('excerpt_length', 'Excerpt::new_length');

    Excerpt::output();
  }

  // Tells WP the new length
  public static function new_length() {
    if( isset(Excerpt::$types[Excerpt::$length]) )
      return Excerpt::$types[Excerpt::$length];
    else
      return Excerpt::$length;
  }

  // Echoes out the excerpt
  public static function output() {


	  $excerpt = preg_replace('`\[[^\]]*\]`', '', the_excerpt());
	  return $excerpt;
  }

}

// An alias to the class
function lightrr__excerpt($length = 55) {
  Excerpt::length($length);
}

function lightrr__domain() {
  $domain = preg_replace('/^www\./','',$_SERVER['SERVER_NAME']);
  if('localhost' == $domain){
		$domain = 'http://'.$domain.'/sanmiguel';
  }
  else{
	  $domain = 'https://'.$domain;
  }
  return $domain;
}


function lightrr__content($limit) {
    $content = explode(' ', get_the_content(), $limit);

    if (count($content) >= $limit) {
        array_pop($content);
        $content = implode(" ", $content) . '...';
    } else {
        $content = implode(" ", $content);
    }

    $content = preg_replace('/\[.+\]/','', $content);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);

    return $content;
}








/* Custom class menu
 =================================================================================================== */

function lightrr_menu_classes($classes, $item, $args) {

	if($args->theme_location == 'lightrr__principal-inferior-menu') { // name need menu
		$classes[] = 'lightrr__main-menu-content-inline-col col-md-6'; // add classes
	}
	return $classes;
}
add_filter('nav_menu_css_class','lightrr_menu_classes',1,3);







function lightrr_svg($name = '') {

	if('xx3' == $name){
		$output = '';
	}
	if('play' == $name){
		$output = '

		<svg width="315px" height="315px" viewBox="0 0 315 315" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
		    <g id="play-button" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
		        <g id="play-button" fill="#FEE447" fill-rule="nonzero">
		            <path d="M293.002,78.53 C249.646,3.435 153.618,-22.296 78.529,21.068 C3.434,64.418 -22.298,160.442 21.066,235.534 C64.416,310.629 160.441,336.364 235.531,293.004 C310.627,249.639 336.371,153.62 293.002,78.53 Z M219.834,265.801 C159.767,300.493 82.94,279.907 48.258,219.828 C13.568,159.761 34.161,82.935 94.23,48.26 C154.301,13.57 231.124,34.154 265.808,94.231 C300.493,154.307 279.906,231.117 219.834,265.801 Z M213.555,150.652 L131.341,102.703 C123.849,98.329 117.806,101.826 117.848,110.492 L118.269,205.666 C118.307,214.33 124.424,217.857 131.938,213.517 L213.523,166.414 C221.029,162.082 221.045,155.026 213.555,150.652 Z" id="Shape"></path>
		        </g>
		    </g>
		</svg>';
	}
	if('icon-slider-arrow' == $name){
		$output = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 41.58 82.73"><defs><style>.cls-1{fill:#00b6e1;}</style></defs><title>Asset 5</title><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><polygon class="cls-1" points="0.43 0 41.58 41.15 0 82.73 0.43 0"/></g></g></svg>';
	}
	if('icon-arrow-feed' == $name){
		$output = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 41 16.36"><defs><style>.cls-1{fill:none;stroke:#00b6e1;stroke-miterlimit:10;stroke-width:2px;}.cls-2{fill:#00b6e1;}</style></defs><title>Asset 3</title><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><line class="cls-1" y1="8.18" x2="39" y2="8.18"/><polygon class="cls-2" points="32.2 16.36 30.84 14.89 38.06 8.18 30.84 1.47 32.2 0 41 8.18 32.2 16.36"/></g></g></svg>';
	}

	if('logofooter' == $name){
		$output = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 72.58 72.26"><defs><style>.cls-1,.cls-2{fill:#fff;}.cls-2{clip-path:url(#clip-path);}.cls-3{clip-path:url(#clip-path-2);}.cls-4{clip-path:url(#clip-path-3);}.cls-5{clip-path:url(#clip-path-4);}</style><clipPath id="clip-path"><path class="cls-1" d="M24.53,17.33"/></clipPath><clipPath id="clip-path-2"><path class="cls-1" d="M32.24,33.56a17,17,0,0,1,2.12-3.63c1-1.3,1.87-2.31,2.1-2.58l.06-.06h0q.63-.67,1.32-1.32l0,0,0,0a17.5,17.5,0,0,1,4.27-3.39A26.8,26.8,0,0,1,54.48,19a23.11,23.11,0,0,1-1.08,4.56,27.07,27.07,0,0,1-7.45,11.19l0,0a22.09,22.09,0,0,1-4.45,3.14V30.73l-5.71-.56c-.45.57-.88,1.15-1.26,1.69l5.16.51V45.78l-6.78,6.15h0l-1.34,1.22c-.16-.46-.34-1-.52-1.74v0a29.55,29.55,0,0,1-1-8.59,26.14,26.14,0,0,0,8.71-1.69V39.18a24.55,24.55,0,0,1-6.4,1.66l-.2,0-.37,0-.24,0-.38,0H31l-.31,0a19.72,19.72,0,0,1-3.92-.12h0a27.51,27.51,0,0,1-6.94-1.73q-.84-.32-1.67-.7l1.34-1.22,6.78-6.15,4.93.48a25.11,25.11,0,0,0-2.73,8.29l1.82.06a23.48,23.48,0,0,1,1.92-6.33M55.45,17.11a31.23,31.23,0,0,0-8.37,1.29A26.51,26.51,0,0,0,41.19,21a19.32,19.32,0,0,0-4.63,3.7,27.66,27.66,0,0,0-4.32,5.14l-6.57-.64L17,37l-.09.07-.08.08a1.81,1.81,0,0,0,0,2.48,1.84,1.84,0,0,0,.48.38l.23.1a29.39,29.39,0,0,0,10.68,2.66,31.2,31.2,0,0,0,1.55,10.86,2,2,0,0,0,.07.2,1.82,1.82,0,0,0,2.8.74l.1-.08.09-.09,8.63-7.83V39.92A24.34,24.34,0,0,0,47.17,36a28.85,28.85,0,0,0,8-12,21.89,21.89,0,0,0,1.24-6l0-.95Z"/></clipPath><clipPath id="clip-path-3"><path class="cls-1" d="M11.32,36.59A24.05,24.05,0,0,0,47.21,57.54a4.77,4.77,0,0,1-1.84-1.26,22.09,22.09,0,1,1,.82-38.95h0q1.28-.4,2.62-.68A24.05,24.05,0,0,0,11.32,36.59"/></clipPath><clipPath id="clip-path-4"><path class="cls-2" d="M59.43,36.59a23.91,23.91,0,0,0-3.28-12.12l-.92,2.46A22.08,22.08,0,0,1,25.38,56.28a4.76,4.76,0,0,1-1.84,1.26A24.06,24.06,0,0,0,59.43,36.59"/></clipPath></defs><title>logo-icon</title><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><path class="cls-1" d="M32.24,33.56a17,17,0,0,1,2.12-3.63c1-1.3,1.87-2.31,2.1-2.58l.06-.06h0q.63-.67,1.32-1.32l0,0,0,0a17.5,17.5,0,0,1,4.27-3.39A26.8,26.8,0,0,1,54.48,19a23.11,23.11,0,0,1-1.08,4.56,27.07,27.07,0,0,1-7.45,11.19l0,0a22.09,22.09,0,0,1-4.45,3.14V30.73l-5.71-.56c-.45.57-.88,1.15-1.26,1.69l5.16.51V45.78l-6.78,6.15h0l-1.34,1.22c-.16-.46-.34-1-.52-1.74v0a29.55,29.55,0,0,1-1-8.59,26.14,26.14,0,0,0,8.71-1.69V39.18a24.55,24.55,0,0,1-6.4,1.66l-.2,0-.37,0-.24,0-.38,0H31l-.31,0a19.72,19.72,0,0,1-3.92-.12h0a27.51,27.51,0,0,1-6.94-1.73q-.84-.32-1.67-.7l1.34-1.22,6.78-6.15,4.93.48a25.11,25.11,0,0,0-2.73,8.29l1.82.06a23.48,23.48,0,0,1,1.92-6.33M55.45,17.11a31.23,31.23,0,0,0-8.37,1.29A26.51,26.51,0,0,0,41.19,21a19.32,19.32,0,0,0-4.63,3.7,27.66,27.66,0,0,0-4.32,5.14l-6.57-.64L17,37l-.09.07-.08.08a1.81,1.81,0,0,0,0,2.48,1.84,1.84,0,0,0,.48.38l.23.1a29.39,29.39,0,0,0,10.68,2.66,31.2,31.2,0,0,0,1.55,10.86,2,2,0,0,0,.07.2,1.82,1.82,0,0,0,2.8.74l.1-.08.09-.09,8.63-7.83V39.92A24.34,24.34,0,0,0,47.17,36a28.85,28.85,0,0,0,8-12,21.89,21.89,0,0,0,1.24-6l0-.95Z"/><g class="cls-3"><rect class="cls-1" x="9.87" y="9.3" width="52.83" height="53.66" transform="translate(-12.93 50.26) rotate(-60.89)"/></g><path class="cls-1" d="M11.32,36.59A24.05,24.05,0,0,0,47.21,57.54a4.77,4.77,0,0,1-1.84-1.26,22.09,22.09,0,1,1,.82-38.95h0q1.28-.4,2.62-.68A24.05,24.05,0,0,0,11.32,36.59"/><g class="cls-4"><rect class="cls-1" x="5.87" y="17.65" width="48.42" height="37.89" transform="translate(-6.75 66.38) rotate(-89.55)"/></g><path class="cls-1" d="M24.53,17.33"/><path class="cls-1" d="M59.43,36.59a23.91,23.91,0,0,0-3.28-12.12l-.92,2.46A22.08,22.08,0,0,1,25.38,56.28a4.76,4.76,0,0,1-1.84,1.26A24.06,24.06,0,0,0,59.43,36.59"/><g class="cls-5"><rect class="cls-1" x="21.73" y="12.38" width="37.89" height="48.42" transform="translate(-0.28 0.32) rotate(-0.44)"/></g></g></g></svg>';
	}
	if('logo' == $name){
		$output = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100.17 67.22"><defs><style>.cls-1{fill:none;}.cls-2{clip-path:url(#clip-path);}.cls-3{fill:url(#linear-gradient);}.cls-4{opacity:0.6;}.cls-5{fill:#1d1d1b;}.cls-6{opacity:0.9;}.cls-7{clip-path:url(#clip-path-2);}.cls-8{fill:url(#linear-gradient-2);}</style><clipPath id="clip-path"><path class="cls-1" d="M30,31.21a15.77,15.77,0,0,1,2-3.38,30.65,30.65,0,0,1,2-2.4l.06-.06h0q.59-.63,1.22-1.22l0,0,0,0a16.27,16.27,0,0,1,4-3.15,25,25,0,0,1,11.43-3.29,21.47,21.47,0,0,1-1,4.24,25.16,25.16,0,0,1-6.93,10.41l0,0a20.66,20.66,0,0,1-4.14,2.92V28.58l-5.31-.52c-.42.53-.82,1.07-1.17,1.58l4.8.47V42.59l-6.3,5.72h0l-1.25,1.13c-.14-.43-.31-1-.48-1.62v0a27.44,27.44,0,0,1-.9-8A24.3,24.3,0,0,0,36,38.25v-1.8a22.87,22.87,0,0,1-6,1.55l-.18,0-.34,0-.23,0-.35,0h-.12l-.29,0A18.34,18.34,0,0,1,24.92,38h0a25.64,25.64,0,0,1-6.46-1.61q-.78-.3-1.55-.65l1.25-1.13,6.3-5.72,4.59.45a23.35,23.35,0,0,0-2.54,7.71l1.69.05A21.84,21.84,0,0,1,30,31.21m21.59-15.3a29,29,0,0,0-7.79,1.2,24.64,24.64,0,0,0-5.48,2.4A17.93,17.93,0,0,0,34,23a25.61,25.61,0,0,0-4,4.78l-6.11-.6-8,7.28-.08.07-.08.07a1.69,1.69,0,0,0,0,2.31,1.66,1.66,0,0,0,.45.35l.21.1a27.33,27.33,0,0,0,9.94,2.48A29,29,0,0,0,27.7,49.9a1.5,1.5,0,0,0,.06.19,1.69,1.69,0,0,0,2.61.68l.09-.07.08-.08,8-7.29v-6.2a22.68,22.68,0,0,0,5.31-3.61,26.84,26.84,0,0,0,7.4-11.17,20.41,20.41,0,0,0,1.16-5.57l0-.88Z"/></clipPath><linearGradient id="linear-gradient" x1="-1953.49" y1="690.03" x2="-1953.36" y2="690.03" gradientTransform="matrix(0, 638.83, 638.83, 0, -440770.29, 1247929.84)" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#1ca7e5"/><stop offset="0.01" stop-color="#1ca7e5"/><stop offset="0.32" stop-color="#168bce"/><stop offset="0.55" stop-color="#127cc2"/><stop offset="0.99" stop-color="#1d5794"/><stop offset="1" stop-color="#1d5794"/></linearGradient><clipPath id="clip-path-2"><path class="cls-1" d="M10.53,34A22.37,22.37,0,0,0,43.91,53.52a4.44,4.44,0,0,1-1.71-1.17A20.55,20.55,0,1,1,43,16.13h0c.79-.25,1.61-.46,2.43-.63A22.37,22.37,0,0,0,10.53,34"/></clipPath><linearGradient id="linear-gradient-2" x1="-1954.92" y1="683.83" x2="-1954.79" y2="683.83" gradientTransform="matrix(406.98, 0.01, 0.01, -406.98, 795607.84, 278350.78)" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#1ca7e5"/><stop offset="0.01" stop-color="#1ca7e5"/><stop offset="0.22" stop-color="#1a9cdc"/><stop offset="0.58" stop-color="#1380c5"/><stop offset="0.62" stop-color="#127cc2"/><stop offset="0.72" stop-color="#1378bd"/><stop offset="0.84" stop-color="#166db0"/><stop offset="0.97" stop-color="#1c5b99"/><stop offset="0.99" stop-color="#1d5794"/><stop offset="1" stop-color="#1d5794"/></linearGradient></defs><title>logo</title><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g class="cls-2"><rect class="cls-3" x="9.19" y="8.65" width="49.14" height="49.91" transform="translate(-12.03 46.75) rotate(-60.89)"/></g><g class="cls-4"><polygon class="cls-5" points="42.93 37.19 47.62 37.19 47.62 37.65 43.43 37.65 43.43 40.38 47.2 40.38 47.2 40.84 43.43 40.84 43.43 43.85 42.93 43.85 42.93 37.19"/></g><g class="cls-4"><polygon class="cls-5" points="51.84 37.19 52.33 37.19 52.33 43.4 56.24 43.4 56.24 43.85 51.84 43.85 51.84 37.19"/></g><g class="cls-4"><polygon class="cls-5" points="61.32 41.22 58.47 37.19 59.08 37.19 61.58 40.77 64.08 37.19 64.67 37.19 61.81 41.21 61.81 43.85 61.32 43.85 61.32 41.22"/></g><g class="cls-6"><path class="cls-5" d="M42.51,49v0a3.37,3.37,0,0,1,3.43-3.44,3.47,3.47,0,0,1,2.61,1l-.75.87a2.65,2.65,0,0,0-1.87-.83A2.24,2.24,0,0,0,43.73,49v0a2.25,2.25,0,0,0,2.2,2.37,2.61,2.61,0,0,0,1.91-.87l.75.76a3.44,3.44,0,0,1-2.7,1.18A3.35,3.35,0,0,1,42.51,49"/></g><g class="cls-6"><path class="cls-5" d="M54.84,45.65h1.08l2.93,6.71H57.62l-.67-1.61H53.79l-.68,1.61h-1.2Zm1.67,4.06L55.37,47l-1.14,2.66Z"/></g><g class="cls-6"><path class="cls-5" d="M62.66,45.69h2.63a2.24,2.24,0,0,1,2.53,2.23v0c0,1.49-1.2,2.27-2.66,2.27H63.83v2.14H62.66Zm2.53,3.46c.88,0,1.44-.49,1.44-1.19v0c0-.78-.56-1.19-1.44-1.19H63.83v2.4Z"/></g><g class="cls-6"><rect class="cls-5" x="71.74" y="45.69" width="1.17" height="6.66"/></g><g class="cls-6"><polygon class="cls-5" points="78.99 46.78 76.88 46.78 76.88 45.69 82.28 45.69 82.28 46.78 80.17 46.78 80.17 52.35 78.99 52.35 78.99 46.78"/></g><g class="cls-6"><path class="cls-5" d="M87.68,45.65h1.08l2.93,6.71H90.46l-.67-1.61H86.64L86,52.35h-1.2Zm1.67,4.06L88.21,47l-1.14,2.66Z"/></g><g class="cls-6"><polygon class="cls-5" points="95.5 45.69 96.67 45.69 96.67 51.28 100.17 51.28 100.17 52.35 95.5 52.35 95.5 45.69"/></g><g class="cls-7"><rect class="cls-8" x="5.46" y="16.41" width="45.04" height="35.24" transform="translate(-6.27 61.75) rotate(-89.56)"/></g></g></g></svg>';
	}

	return $output;

}




























/* Require
 =================================================================================================== */

define( 'CS_ACTIVE_METABOX', false );
define( 'CS_ACTIVE_SHORTCODE', false );
define( 'CS_ACTIVE_CUSTOMIZE', false );

// if ( cs_get_option('set_theme_slider', true) ) { // Custom Gallery
// 	require (get_template_directory() . '/inc/gallery.php');
// }
require (get_template_directory() . '/cs-options.php'); // Theme Options
require (get_template_directory() . '/inc/template-tags.php'); // Custom Template Tags
// require (get_template_directory() . '/inc/widgets.php'); // Load Sidebar Widgets
// require (get_template_directory() . '/inc/category-color.php'); // Category Colors
// require (get_template_directory() . '/inc/stylevar.php'); // Dynamic Style
// require (get_template_directory() . '/inc/metabox.php'); // Metabox
